import {createStructuredSelector} from 'reselect';

import {IOrderAuthorization} from 'reducers/common/checkOrderAuthorization/reducer';
import {StoreInterface} from 'reducers/storeTypes';
import {TUserInfo} from 'reducers/common/commonReducerTypes';

import {getUserInfo} from 'selectors/common/userInfoSelector';

export interface ICheckAuthorizationFormSelector {
    orderAuthorization: IOrderAuthorization;
    userInfo: TUserInfo;
}

export type getOrderAuthorizationType = (
    store: StoreInterface,
) => IOrderAuthorization;

export const getOrderAuthorization: getOrderAuthorizationType = state =>
    state.common.orderAuthorization;

export default createStructuredSelector<
    StoreInterface,
    ICheckAuthorizationFormSelector
>({
    orderAuthorization: getOrderAuthorization,
    userInfo: getUserInfo,
});
