import {createSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

import {PriceConverter} from 'utilities/currency/priceConverter';
import {PriceComparator} from 'utilities/currency/compare';

export const currenciesSelector = (state: StoreInterface) =>
    state.common.currencies.data;

export const currenciesConverterSelector = createSelector(
    currenciesSelector,
    currenciesInfo =>
        new PriceConverter({
            currenciesInfo,
        }),
);

export const priceComparatorSelector = createSelector(
    currenciesConverterSelector,
    priceConverter => new PriceComparator(priceConverter),
);
