import {createSelector} from 'reselect';

import {aviaPlatformSelector} from 'selectors/avia/platform/aviaPlatformSelector';
import {getUserInfo} from 'selectors/common/userInfoSelector';

/** Селектор = web сайт и (яндекс сотрудник или внутренняя сеть яндекс) */
export default createSelector(
    aviaPlatformSelector,
    getUserInfo,
    (platform, userInfo): boolean => {
        return (
            platform.isWeb &&
            (('isStaff' in userInfo && userInfo.isStaff) ||
                Boolean(userInfo.isYandexNetwork))
        );
    },
);
