import {IPreviousSearchFormStore} from 'reducers/common/previousSearchForm/types';

import {StoreInterface} from 'reducers/storeTypes';

export const previousFormsValuesSelector = (
    state: StoreInterface,
): IPreviousSearchFormStore => state.common.previousSearchForm || {};

export const previousFormValuesByFormNameSelector = <
    T extends keyof IPreviousSearchFormStore,
>(
    state: StoreInterface,
    formName: T,
): Partial<IPreviousSearchFormStore[T]> =>
    state.common.previousSearchForm?.[formName] || {};
