import {IUserPlusInfo} from 'types/common/userInfo/TBlackboxUserInfo';

import {StoreInterface} from 'reducers/storeTypes';
import {
    TUserInfo,
    IGeoLocation,
    IAuthUserInfo,
} from 'reducers/common/commonReducerTypes';

import {isAuthUser} from 'utilities/userInfo/isAuthUser';

/**
 * Используйте useUserInfo hook для доставки данных в компоненты
 * @param state
 */
export const getUserInfo = (state: StoreInterface): TUserInfo =>
    state.common.userInfo;

export const getUserPlusInfo = (state: StoreInterface): IUserPlusInfo => {
    const userInfo = getUserInfo(state) as IAuthUserInfo;

    if (isAuthUser(userInfo)) {
        return {
            hasPlus: userInfo.plusInfo?.hasPlus ?? false,
            points: userInfo.plusInfo?.points,
        };
    }

    return {
        hasPlus: false,
    };
};

export const getUserGeoLocation = (state: StoreInterface): IGeoLocation =>
    getUserInfo(state).geoLocation || {};

export const getUserEmail = (state: StoreInterface): string | undefined => {
    const userInfo = getUserInfo(state);

    return isAuthUser(userInfo) ? userInfo.contacts.email : undefined;
};
