import {createStructuredSelector} from 'reselect';
import {Overwrite} from 'utility-types';

import {IHappyPageStore} from 'reducers/happyPage/types/IHappyPageStore';
import {EOrderApiType} from 'server/api/OrdersAPI/enums/types';
import {IHappyPageAviaServiceResponse} from 'server/services/OrdersService/types/TGetOrderHappyPageServiceResponse';

import {StoreInterface} from 'reducers/storeTypes';
import {IDevice} from 'reducers/common/commonReducerTypes';

import deviceTypeSelector from 'selectors/common/deviceTypeSelector';
import {aviaAeroflotPlusSelector} from 'projects/avia/selectors/aviaAeroflotPlusEnabledSelector';

interface IHappyPageSelector {
    happyPageInfo: Overwrite<
        IHappyPageStore,
        {
            value: IHappyPageAviaServiceResponse | null;
        }
    >;
    deviceType: IDevice;
    aviaAeroflotPlus: boolean;
}

export default createStructuredSelector<StoreInterface, IHappyPageSelector>({
    happyPageInfo: state => {
        return {
            ...state.happyPage,
            value:
                state.happyPage.value?.orderType === EOrderApiType.AVIA
                    ? state.happyPage.value
                    : null,
        };
    },
    deviceType: deviceTypeSelector,
    aviaAeroflotPlus: aviaAeroflotPlusSelector,
});
