import {createSelector} from 'reselect';

import {EOrderApiType} from 'server/api/OrdersAPI/enums/types';

import {StoreInterface} from 'reducers/storeTypes';

const busHappyPageSelector = createSelector(
    (state: StoreInterface) => state.happyPage,
    happyPageInfo => ({
        ...happyPageInfo,
        value:
            happyPageInfo.value?.orderType === EOrderApiType.BUS
                ? happyPageInfo.value
                : null,
    }),
);

export default busHappyPageSelector;
