import {createStructuredSelector} from 'reselect';
import {Overwrite} from 'utility-types';

import {IHappyPageStore} from 'reducers/happyPage/types/IHappyPageStore';
import {EOrderApiType} from 'server/api/OrdersAPI/enums/types';
import {IHappyPageTrainServiceResponse} from 'server/services/OrdersService/types/TGetOrderHappyPageServiceResponse';

import {StoreInterface} from 'reducers/storeTypes';

interface IHappyPageSelector {
    happyPageInfo: Overwrite<
        IHappyPageStore,
        {
            value: IHappyPageTrainServiceResponse | null;
        }
    >;
}

export default createStructuredSelector<StoreInterface, IHappyPageSelector>({
    happyPageInfo: state => {
        return {
            ...state.happyPage,
            value:
                state.happyPage.value?.orderType === EOrderApiType.TRAIN
                    ? state.happyPage.value
                    : null,
        };
    },
});
