import {createSelector} from 'reselect';

import {getOfferInfoByToken} from 'selectors/hotels/book/getBookOfferInfo';
import {getOrderInfo} from 'selectors/hotels/book/getBookOrderInfo';

import getAmountPaidAndTotalPriceAfterPlusWithdraw from 'projects/account/pages/Order/components/OrderHotels/utilities/getAmountPaidAndTotalPriceAfterPlusWithdraw';

const amountPaidAndTotalPriceAfterPlusWithdrawSelector = createSelector(
    [getOfferInfoByToken, getOrderInfo],
    (offerInfoByToken, orderInfo) => {
        const {offerInfo} = offerInfoByToken;

        if (!offerInfo) {
            return {};
        }

        return getAmountPaidAndTotalPriceAfterPlusWithdraw({
            offerInfo,
            orderInfo,
        });
    },
);

export default amountPaidAndTotalPriceAfterPlusWithdrawSelector;
