import {IBookUserSelect} from 'types/hotels/book/ICreateOrder';

import {StoreInterface} from 'reducers/storeTypes';
import {IBookPromoCodesReducer} from 'reducers/hotels/bookAndPayPage/promoCodesInfo/reducer';

import experimentsSelector from 'selectors/common/experimentsSelector';
import {whiteLabelConfigSelector} from 'selectors/common/whiteLabelConfigSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

type TGetBookUserSelect = (store: StoreInterface) => IBookUserSelect;

const getBookUserSelect: TGetBookUserSelect = (store: StoreInterface) =>
    store.hotels.bookAndPay.bookUserSelect;

const getPromoCodesInfoSelect = (
    state: StoreInterface,
): IBookPromoCodesReducer => state.hotels.bookAndPay.promoCodesInfo;

export default createTypedStructuredSelector({
    bookUserSelect: getBookUserSelect,
    promoCodesInfo: getPromoCodesInfoSelect,
    experiments: experimentsSelector,
    whiteLabelConfig: whiteLabelConfigSelector,
});
