import {createStructuredSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';
import {IOrderCancelAndRefundableInfo} from 'reducers/hotels/bookAndPayPage/orderCancelAndRefundableInfo/reducer';

export interface IOrderCancelAndRefundableSelector {
    orderCancelAndRefundableInfo: IOrderCancelAndRefundableInfo;
}

export const getOrderCancelAndRefundableInfo = (
    store: StoreInterface,
): IOrderCancelAndRefundableInfo =>
    store.hotels.bookAndPay.orderCancelAndRefundableInfo;

export default createStructuredSelector<
    StoreInterface,
    IOrderCancelAndRefundableSelector
>({
    orderCancelAndRefundableInfo: getOrderCancelAndRefundableInfo,
});
