import {createStructuredSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';
import {IGeoRegionInfoReducer} from 'reducers/hotels/geoRegionPage/reducer';

import nonceSelector from 'selectors/common/nonceSelector';

/* Getters */
export const getGeoRegionInfo = (
    store: StoreInterface,
): IGeoRegionInfoReducer => store.hotels.geoRegionPage;

/* Types */
export interface IGeoRegionPageSelector {
    geoRegionInfo: ReturnType<typeof getGeoRegionInfo>;
    schemaNonce: ReturnType<typeof nonceSelector>;
}

/* Selectors */
export default createStructuredSelector<StoreInterface, IGeoRegionPageSelector>(
    {
        geoRegionInfo: getGeoRegionInfo,
        schemaNonce: nonceSelector,
    },
);
