import {createStructuredSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

import {
    getHotelFeatureRatings,
    THotelFeatureRatingsSelectorType,
} from './getHotelFeatureRatings';
import {totalReviewCountSelector} from './totalReviewsCountSelector';
import {getHotelReviews, THotelReviewsSelectorType} from './getHotelReviews';

export interface IHotelFeatureRatingsSelector {
    hotelReviews: THotelReviewsSelectorType;
    hotelFeatureRatingsInfo: THotelFeatureRatingsSelectorType;
    totalReviewCount: number;
}

export default createStructuredSelector<
    StoreInterface,
    IHotelFeatureRatingsSelector
>({
    hotelReviews: getHotelReviews,
    hotelFeatureRatingsInfo: getHotelFeatureRatings,
    totalReviewCount: totalReviewCountSelector,
});
