import {createSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

/* Getters */
import {getHotelReviews} from './getHotelReviews';

export const totalReviewCountSelector = createSelector<
    StoreInterface,
    ReturnType<typeof getHotelReviews>,
    number
>(
    getHotelReviews,
    (hotelReviews: ReturnType<typeof getHotelReviews>): number => {
        const {
            data: {totalTextReviewCount, keyPhrases},
            activeKeyPhrase,
        } = hotelReviews;

        let reviewsLimit = totalTextReviewCount;

        if (activeKeyPhrase) {
            const item = keyPhrases.find(
                keyPhrase => keyPhrase.name === activeKeyPhrase,
            );

            if (item) {
                reviewsLimit = item.reviewCount;
            }
        }

        return reviewsLimit;
    },
);
