import {createSelector} from 'reselect';

import {getHotelsCurrentFilters} from 'selectors/hotels/search/filters/hotelsFiltersSelector';
import deviceTypeSelector from 'selectors/common/deviceTypeSelector';

import {flatHotelFilters} from 'projects/hotels/utilities/filters/flatHotelFilters';
import {calculateTotalFilterGroups} from 'projects/hotels/utilities/filters/calculateTotalFilterGroups';
import {calculateTotalPriceFilter} from 'projects/hotels/utilities/filters/calculateTotalPriceFilter';

export const getTotalActiveFilters = createSelector(
    [getHotelsCurrentFilters, deviceTypeSelector],
    currentFilters => {
        const {priceFilter, activeFilterAtoms, detailedFiltersBatches} =
            currentFilters;

        const totalPriceFilter = calculateTotalPriceFilter(priceFilter);
        const totalActiveTotalFilterGroups = calculateTotalFilterGroups(
            flatHotelFilters(detailedFiltersBatches),
            activeFilterAtoms,
        );

        return totalPriceFilter + totalActiveTotalFilterGroups;
    },
);
