import {ESearchBanner} from 'reducers/hotels/searchPage/search/reducer';

import {getHasPromocodeTaxi} from 'selectors/hotels/search/searchHotels/getHasPromocodeTaxi';
import {getSearchInfo} from 'selectors/hotels/search/searchHotels/getSearchInfo';
import {getSortInfo} from 'selectors/hotels/search/sort/getSortInfo';
import mirCashbackSearchIsExpandedSelector from 'selectors/common/togglers/mirCashbackSearchIsExpandedSelector';
import experimentsSelector from 'selectors/common/experimentsSelector';
import {hotelsFiltersSelector} from 'projects/hotels/pages/SearchPage/components/SearchFilters/selectors/hotelsFiltersSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    hasSearchData: state => Boolean(getSearchInfo(state).data),
    isLoading: state => {
        const searchInfo = getSearchInfo(state);

        return (
            searchInfo.isLoading ||
            !searchInfo.data?.offerSearchProgress.finished
        );
    },
    hasMirBanner: state =>
        getSearchInfo(state).data?.searchBannerType === ESearchBanner.MIR,
    hasPromoTaxi: getHasPromocodeTaxi,
    hasSort: state =>
        Boolean(getSortInfo(state).sortInfo?.availableSortTypeGroups?.length),
    isMirCashbackExpanded: mirCashbackSearchIsExpandedSelector,
    filters: hotelsFiltersSelector,
    experiments: experimentsSelector,
});
