import {createSelector} from 'reselect';

import {getHotelList} from 'selectors/hotels/search/hotelList/getHotelList';

import {getHotelTaxiPromocodeBadge} from 'projects/hotels/utilities/getHotelBadges/getHotelTaxiPromocodeBadge';

import {getSearchInfo} from './getSearchInfo';

export const getHasPromocodeTaxi = createSelector(
    [getHotelList, getSearchInfo],
    (hotelList, search): boolean => {
        const hotelsWithOffersByPermalink =
            search.data?.hotelWithOffersByPermalink;

        if (!hotelsWithOffersByPermalink) {
            return false;
        }

        return hotelList.hotels.some(permalink => {
            const hotel = hotelsWithOffersByPermalink[permalink];

            return getHotelTaxiPromocodeBadge(hotel?.badges);
        });
    },
);
