import {createSelector} from 'reselect';

import {getOfferSearchParams} from 'selectors/hotels/search/searchHotels/getOfferSearchParams';

import {getTotalNights as getTotalNightsHelper} from 'projects/hotels/utilities/calculateTotalNights/calculateTotalNights';

export const getTotalNights = createSelector(
    [getOfferSearchParams],
    offerSearchParams => {
        return offerSearchParams
            ? getTotalNightsHelper(
                  offerSearchParams.checkinDate,
                  offerSearchParams.checkoutDate,
              )
            : 0;
    },
);
