import {fromFieldSelector} from 'selectors/tours/searchForm/fromFieldSelector';
import {toFieldSelector} from 'selectors/tours/searchForm/toFieldSelector';
import {startDateSelector} from 'selectors/tours/searchForm/startDateSelector';
import {searchSuggestsSelector} from 'selectors/tours/searchForm/searchSuggestSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    fromField: fromFieldSelector,
    toField: toFieldSelector,
    startDateField: startDateSelector,
    flexibleDatesField: state => state.tours.searchForm.flexibleDates,
    flexibleNightsField: state => state.tours.searchForm.flexibleNights,
    nightsField: state => state.tours.searchForm.nightsCount,
    adultsField: state => state.tours.searchForm.adults,
    childrenAgesField: state => state.tours.searchForm.childrenAges,
    searchSuggests: searchSuggestsSelector,
});
