import {
    ITrainsVariantsAndDirection,
    TTrainsVariantId,
} from 'types/trains/common/variant/ITrainsVariant';
import {ITrainsNonRefundableTariffVariantsInfo} from 'types/trains/search/badgesInfo/ITrainsSearchBadgesInfo';

import {checkHasTrainsVariantNonRefundableTariff} from 'projects/trains/lib/genericSearch/variants/checkHasTrainsVariantNonRefundableTariff';

const DEFAULT_NON_REFUNDABLE_TARIFF_VARIANTS_INFO: ITrainsNonRefundableTariffVariantsInfo =
    {
        variantIds: [],
    };

export const getNonRefundableTariffVariantsInfo = (
    variantsAndDirection: ITrainsVariantsAndDirection,
): ITrainsNonRefundableTariffVariantsInfo => {
    const {variants, direction} = variantsAndDirection;

    if (!variants?.length) {
        return DEFAULT_NON_REFUNDABLE_TARIFF_VARIANTS_INFO;
    }

    const variantIds = variants.reduce<TTrainsVariantId[]>(
        (resultVariantIds, variant) => {
            const hasTrainsVariantNonRefundableTariff =
                checkHasTrainsVariantNonRefundableTariff({variant, direction});

            if (hasTrainsVariantNonRefundableTariff) {
                resultVariantIds.push(variant.id);
            }

            return resultVariantIds;
        },
        [],
    );

    if (!variantIds.length) {
        return DEFAULT_NON_REFUNDABLE_TARIFF_VARIANTS_INFO;
    }

    return {
        variantIds,
    };
};
