import {ETrainsFeatureType} from 'types/trains/common/features/ETrainsFeatureType';
import {
    TTrainsVariantId,
    ITrainsVariantsAndDirection,
} from 'types/trains/common/variant/ITrainsVariant';
import {ITrainsWithoutERegistrationVariantsInfo} from 'types/trains/search/badgesInfo/ITrainsSearchBadgesInfo';

import {getTrainsVariantMinPrice} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantMinPrice';
import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';

const DEFAULT_WITHOUT_E_REGISTRATION_VARIANTS_INFO: ITrainsWithoutERegistrationVariantsInfo =
    {
        variantIds: [],
    };

export const getWithoutERegistrationVariantsInfo = (
    variantsAndDirection: ITrainsVariantsAndDirection,
): ITrainsWithoutERegistrationVariantsInfo => {
    const {variants, direction} = variantsAndDirection;

    if (!variants?.length) {
        return DEFAULT_WITHOUT_E_REGISTRATION_VARIANTS_INFO;
    }

    const variantIds = variants.reduce<TTrainsVariantId[]>(
        (resultVariantIds, variant) => {
            const hasTrainsVariantTariffs = Boolean(
                getTrainsVariantMinPrice({variant, direction}),
            );

            if (hasTrainsVariantTariffs) {
                const segments = getTrainsVariantSegments({variant, direction});
                const hasSegmentWithoutERegistration = segments.some(
                    segment => {
                        return !segment.features?.[ETrainsFeatureType.ETICKET];
                    },
                );

                if (hasSegmentWithoutERegistration) {
                    resultVariantIds.push(variant.id);
                }
            }

            return resultVariantIds;
        },
        [],
    );

    if (!variantIds.length) {
        return DEFAULT_WITHOUT_E_REGISTRATION_VARIANTS_INFO;
    }

    return {
        variantIds,
    };
};
