import {createSelector} from 'reselect';

import {ITrainsSearchBadgesInfo} from 'types/trains/search/badgesInfo/ITrainsSearchBadgesInfo';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';

import {StoreInterface} from 'reducers/storeTypes';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import trainsSearchVariantsSelector from 'selectors/trains/genericSearch/search/trainsSearchVariantsSelector';

import {getCheapestVariantsInfo} from './getCheapestVariantsInfo';
import {getFastestVariantsInfo} from './getFastestVariantsInfo';
import {getWithoutERegistrationVariantsInfo} from './getWithoutERegistrationVariantsInfo';
import {getNonRefundableTariffVariantsInfo} from './getNonRefundableTariffVariantsInfo';
import {trainsFilteredVariantsSelector} from '../search/trainsSearchInfoSelector';

function getBadgesInfoSelector(
    variantsSelector: (state: StoreInterface) => ITrainsVariant[],
): (state: StoreInterface) => ITrainsSearchBadgesInfo {
    return createSelector(
        variantsSelector,
        trainsContextSelector,
        (variants, context): ITrainsSearchBadgesInfo => {
            const {direction} = context;

            return {
                cheapestVariantsInfo: getCheapestVariantsInfo({
                    variants,
                    direction,
                }),
                fastestVariantsInfo: getFastestVariantsInfo({
                    variants,
                    direction,
                }),
                withoutERegistrationVariantsInfo:
                    getWithoutERegistrationVariantsInfo({
                        variants,
                        direction,
                    }),
                nonRefundableTariffVariantsInfo:
                    getNonRefundableTariffVariantsInfo({
                        variants,
                        direction,
                    }),
            };
        },
    );
}

export const trainsBadgesInfoSelector = getBadgesInfoSelector(
    trainsFilteredVariantsSelector,
);

export const trainsDirectionPageBadgesInfoSelector = getBadgesInfoSelector(
    trainsSearchVariantsSelector,
);
