import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {ETrainsFeatureType} from 'types/trains/common/features/ETrainsFeatureType';

interface ITrainsElectronicTicketAndDynamicPricingChecks {
    hasElectronicTicket: boolean;
    hasDynamicPricing: boolean;
}

const DEFAULT_DISCLAIMERS_INFO: ITrainsElectronicTicketAndDynamicPricingChecks =
    {
        hasElectronicTicket: false,
        hasDynamicPricing: false,
    };

export const checkTrainsElectronicTicketAndDynamicPricing = (
    variants: ITrainsVariant[],
): ITrainsElectronicTicketAndDynamicPricingChecks => {
    if (!variants || variants.length === 0) {
        return DEFAULT_DISCLAIMERS_INFO;
    }

    return variants.reduce<ITrainsElectronicTicketAndDynamicPricingChecks>(
        (currentDisclaimersInfo, variant) => {
            const segments = variant.forward;
            let hasElectronicTicket =
                currentDisclaimersInfo.hasElectronicTicket;
            let hasDynamicPricing = currentDisclaimersInfo.hasDynamicPricing;

            if (segments?.length) {
                segments.forEach(segment => {
                    const {features} = segment;

                    if (features?.[ETrainsFeatureType.ETICKET]) {
                        hasElectronicTicket = true;
                    }

                    if (features?.[ETrainsFeatureType.DYNAMIC_PRICING]) {
                        hasDynamicPricing = true;
                    }
                });
            }

            return {
                hasDynamicPricing,
                hasElectronicTicket,
            };
        },
        DEFAULT_DISCLAIMERS_INFO,
    );
};
