import {createSelector} from 'reselect';

import {ITrainsGeneralDisclaimersInfo} from 'types/trains/search/disclaimersInfo/ITrainsGeneralDisclaimersInfo';
import {
    isFilledTrainsSearchContext,
    TrainsSearchContextType,
} from 'reducers/trains/context/types';
import {TExperiments} from 'server/providers/experiments/types';

import {StoreInterface} from 'reducers/storeTypes';

import experimentsSelector from 'selectors/common/experimentsSelector';
import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import {trainsPurchaseIsAvailableSelector} from 'selectors/trains/trainsPurchaseIsAvailableSelector';
import {getTrainsOriginalSearchInfo} from 'selectors/trains/genericSearch/search/getTrainsOriginalSearchInfo';

import isIncompleteScheduleDisclaimerAvailable from 'projects/trains/lib/disclaimers/isIncompleteScheduleDisclaimerAvailable';
import {checkHasNearestTrainDatesByContext} from 'projects/trains/lib/genericSearch/nearestTrainDates/checkHasNearestTrainDatesByContext';

import {checkAllVariantsWithTransferCase} from './checkAllVariantsWithTransferCase';
import {checkTrainsElectronicTicketAndDynamicPricing} from './checkTrainsElectronicTicketAndDynamicPricing';
import {ITrainsSearchInfoSelector} from '../search/trainsSearchInfoSelector';

export const trainsDisclaimersInfoSelector = createSelector<
    StoreInterface,
    ITrainsSearchInfoSelector,
    TrainsSearchContextType,
    ReturnType<typeof trainsPurchaseIsAvailableSelector>,
    TExperiments,
    ITrainsGeneralDisclaimersInfo
>(
    getTrainsOriginalSearchInfo,
    trainsContextSelector,
    trainsPurchaseIsAvailableSelector,
    experimentsSelector,
    (
        originalSearchInfo,
        searchContext,
        isPurchaseAvailable,
        experiments,
    ): ITrainsGeneralDisclaimersInfo => {
        const {variants, nearestTrainDatesByDirection} = originalSearchInfo;
        const {hasDynamicPricing, hasElectronicTicket} =
            checkTrainsElectronicTicketAndDynamicPricing(variants);
        const {trainsNearestTrainDates: trainsNearestTrainDatesEnabled} =
            experiments;
        const hasNearestTrainDates =
            trainsNearestTrainDatesEnabled &&
            checkHasNearestTrainDatesByContext({
                searchContext,
                nearestTrainDatesByDirection,
            });

        return {
            hasDynamicPricing,
            hasElectronicTicket,
            isPurchaseAvailable,
            areVariantsWithTransfer:
                !hasNearestTrainDates &&
                checkAllVariantsWithTransferCase(variants),
            isContextChanged: Boolean(
                searchContext.isChanged && searchContext.original,
            ),
            isIncompleteScheduleDisclaimerAvailable:
                isFilledTrainsSearchContext(searchContext)
                    ? isIncompleteScheduleDisclaimerAvailable(searchContext)
                    : false,
        };
    },
);
