import {createSelector} from 'reselect';

import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';
import {
    ITrainsFilteredVariantsInfo,
    TTrainsVariantWithVisibleStatusById,
} from 'types/trains/common/variant/ITrainsVariant';
import {TrainsSearchContextType} from 'reducers/trains/context/types';

import {StoreInterface} from 'reducers/storeTypes';
import {ITrainsSearchReducer} from 'reducers/trains/genericSearch/search/reducer';
import {TTrainsSearchFiltersReducer} from 'reducers/trains/genericSearch/filters/reducer';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import {getTrainsOriginalSearchInfo} from 'selectors/trains/genericSearch/search/getTrainsOriginalSearchInfo';
import {
    trainsFilteredVariantsInfoSelector,
    trainsOriginalVariantWithVisibleStatusByIdSelector,
} from 'selectors/trains/genericSearch/search/trainsSearchInfoSelector';
import {getTrainsOriginalSearchFilters} from 'selectors/trains/genericSearch/filters/getTrainsOriginalSearchFilters';

import {updateTrainsFilterActiveOptionsAndMinPrices} from 'projects/trains/lib/genericSearch/filters/updateTrainsFilterActiveOptionsAndMinPrices';

export const trainsSearchFiltersInfoSelector = createSelector<
    StoreInterface,
    TrainsSearchContextType,
    ITrainsSearchReducer,
    TTrainsSearchFiltersReducer,
    ITrainsFilteredVariantsInfo,
    TTrainsVariantWithVisibleStatusById,
    ITrainsFilters | null
>(
    trainsContextSelector,
    getTrainsOriginalSearchInfo,
    getTrainsOriginalSearchFilters,
    trainsFilteredVariantsInfoSelector,
    trainsOriginalVariantWithVisibleStatusByIdSelector,
    (
        context,
        originalSearchInfo,
        filters,
        filteredVariantsInfo,
        originalVariantWithVisibleStatusById,
    ): ITrainsFilters | null => {
        return updateTrainsFilterActiveOptionsAndMinPrices({
            context,
            filters,
            originalSearchInfo,
            filteredVariantsInfo,
            originalVariantWithVisibleStatusById,
        });
    },
);
