import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';

export const trainsSortBaseCompareFunctionByDiffWithReverse = ({
    sortInfo,
    variantsDiff,
}: {
    sortInfo: ITrainsSearchSort;
    variantsDiff: number;
}): number => {
    const {isReverse} = sortInfo;
    const variantsDiffWithReverse = (isReverse ? -1 : 1) * variantsDiff;

    if (variantsDiffWithReverse > 0) {
        return 1;
    }

    return -1;
};
