import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';

import IPrice from 'utilities/currency/PriceInterface';
import {getTrainsVariantMinPrice} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantMinPrice';

import {TTrainsCompareFunctionCreator} from './trainsSortVaraints';
import {trainsSortBaseCompareFunctionByDiffWithReverse} from './trainsSortBaseCompareFunctionByDiffWithReverse';

const updatePriceValueForSoldOutVariant = ({
    price,
    sortInfo,
}: {
    price?: IPrice;
    sortInfo: ITrainsSearchSort;
}): number => {
    if (!price) {
        return sortInfo.isReverse ? -Infinity : Infinity;
    }

    return price.value;
};

const trainsSortVariantsComparatorByPrice: TTrainsCompareFunctionCreator = ({
    sortInfo,
    direction,
}) => {
    return (currentVariant, nextVariant): number => {
        const currentVariantMinPrice = getTrainsVariantMinPrice({
            variant: currentVariant,
            direction,
        });
        const nextVariantMinPrice = getTrainsVariantMinPrice({
            variant: nextVariant,
            direction,
        });
        const currentVariantMinPriceValue = updatePriceValueForSoldOutVariant({
            sortInfo,
            price: currentVariantMinPrice,
        });
        const nextVariantMinPriceValue = updatePriceValueForSoldOutVariant({
            sortInfo,
            price: nextVariantMinPrice,
        });

        return trainsSortBaseCompareFunctionByDiffWithReverse({
            sortInfo,
            variantsDiff:
                currentVariantMinPriceValue - nextVariantMinPriceValue,
        });
    };
};

export default trainsSortVariantsComparatorByPrice;
