import {EDirection} from 'types/common/EDirection';
import {ESortType} from 'types/common/sort/ESortType';
import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';
import {TrainsSearchContextType} from 'reducers/trains/context/types';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';

import trainsSortVariantsByPrice from './trainsSortByPrice';
import trainsSortVariantsByArrival from './trainsSortVariantsByArrival';
import trainsSortVariantsByDuration from './trainsSortVariantsByDuration';
import trainsSortVariantsByDeparture from './trainsSortVariantsByDeparture';

export type TTrainsCompareFunction = (
    a: ITrainsVariant,
    b: ITrainsVariant,
) => number;
export type TTrainsCompareFunctionCreator = ({
    sortInfo,
    direction,
}: {
    sortInfo: ITrainsSearchSort;
    direction?: EDirection | null;
}) => TTrainsCompareFunction;

const getTrainsSortCompareFunctionCreator = (
    sortInfo: ITrainsSearchSort,
): TTrainsCompareFunctionCreator => {
    const {by} = sortInfo;

    switch (by) {
        case ESortType.ARRIVAL: {
            return trainsSortVariantsByArrival;
        }

        case ESortType.DEPARTURE: {
            return trainsSortVariantsByDeparture;
        }

        case ESortType.DURATION: {
            return trainsSortVariantsByDuration;
        }

        case ESortType.PRICE: {
            return trainsSortVariantsByPrice;
        }
    }
};

export const trainsSortVariants = ({
    sortInfo,
    variants,
    context,
}: {
    sortInfo: ITrainsSearchSort;
    variants: ITrainsVariant[];
    context: TrainsSearchContextType;
}): ITrainsVariant[] => {
    const compareFunctionCreator =
        getTrainsSortCompareFunctionCreator(sortInfo);
    const {direction} = context;
    const compareFunction = compareFunctionCreator({sortInfo, direction});

    return variants.sort(compareFunction);
};
