import moment from 'moment-timezone';

import {TTrainsCompareFunctionCreator} from 'selectors/trains/genericSearch/sort/trainsSortVaraints';

import {getTrainsVariantArrival} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantArrival';

import {trainsSortBaseCompareFunctionByDiffWithReverse} from './trainsSortBaseCompareFunctionByDiffWithReverse';

const trainsSortVariantsComparatorByArrival: TTrainsCompareFunctionCreator = ({
    sortInfo,
    direction,
}) => {
    return (currentVariant, nextVariant): number => {
        const currentVariantArrival = getTrainsVariantArrival({
            variant: currentVariant,
            direction,
        });
        const nextVariantArrival = getTrainsVariantArrival({
            variant: nextVariant,
            direction,
        });

        if (!currentVariantArrival || !nextVariantArrival) {
            return 0;
        }

        return trainsSortBaseCompareFunctionByDiffWithReverse({
            sortInfo,
            variantsDiff: moment(currentVariantArrival).diff(
                nextVariantArrival,
                'seconds',
            ),
        });
    };
};

export default trainsSortVariantsComparatorByArrival;
