import moment from 'moment-timezone';

import {TTrainsCompareFunctionCreator} from 'selectors/trains/genericSearch/sort/trainsSortVaraints';

import {getTrainsVariantDeparture} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantDeparture';

import {trainsSortBaseCompareFunctionByDiffWithReverse} from './trainsSortBaseCompareFunctionByDiffWithReverse';

const trainsSortVariantsComparatorByDeparture: TTrainsCompareFunctionCreator =
    ({sortInfo, direction}) => {
        return (currentVariant, nextVariant): number => {
            const currentVariantDeparture = getTrainsVariantDeparture({
                variant: currentVariant,
                direction,
            });
            const nextVariantDeparture = getTrainsVariantDeparture({
                variant: nextVariant,
                direction,
            });

            if (!currentVariantDeparture || !nextVariantDeparture) {
                return 0;
            }

            return trainsSortBaseCompareFunctionByDiffWithReverse({
                sortInfo,
                variantsDiff: moment(currentVariantDeparture).diff(
                    nextVariantDeparture,
                    'seconds',
                ),
            });
        };
    };

export default trainsSortVariantsComparatorByDeparture;
