import {TTrainsCompareFunctionCreator} from 'selectors/trains/genericSearch/sort/trainsSortVaraints';

import {getTrainsVariantDuration} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantDuration';

import {trainsSortBaseCompareFunctionByDiffWithReverse} from './trainsSortBaseCompareFunctionByDiffWithReverse';

const trainsSortVariantsComparatorByDuration: TTrainsCompareFunctionCreator = ({
    sortInfo,
    direction,
}) => {
    return (currentVariant, nextVariant): number => {
        const currentVariantDuration = getTrainsVariantDuration({
            variant: currentVariant,
            direction,
        });
        const nextVariantDuration = getTrainsVariantDuration({
            variant: nextVariant,
            direction,
        });

        if (!currentVariantDuration || !nextVariantDuration) {
            return 0;
        }

        return trainsSortBaseCompareFunctionByDiffWithReverse({
            sortInfo,
            variantsDiff: currentVariantDuration - nextVariantDuration,
        });
    };
};

export default trainsSortVariantsComparatorByDuration;
