import {createSelector} from 'reselect';
import intersection from 'lodash/intersection';

import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

import {ITrainOrderState} from 'reducers/trains/order/types';

import trainListSelector from 'selectors/trains/order/trainListSelector';

/**
 * Список разрешенных документов разрешенный для заказа
 * вычисляется как пересечение множеств доступных документов для всех поездов в заказе
 */
const allowedDocumentTypesSelector = createSelector(
    [trainListSelector],
    (trains: ITrainOrderState[]): TRAINS_DOCUMENT_TYPES[] => {
        return intersection(
            ...trains.map(train => {
                return (
                    train.trainDetails?.trainDetails?.allowedDocumentTypes ?? []
                );
            }),
        );
    },
);

export default allowedDocumentTypesSelector;
