import {createSelector} from 'reselect';
import intersection from 'lodash/intersection';

import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';

import {ITrainOrderState} from 'reducers/trains/order/types';

import trainListSelector from 'selectors/trains/order/trainListSelector';

/**
 * Список разрешенных бонусных карт
 * вычисляется как пересечение множеств доступных бонусных карт для всех поездов в заказе
 */
const availableLoyaltyCardsSelector = createSelector(
    [trainListSelector],
    (trains: ITrainOrderState[]): TRAIN_BONUS_CARDS[] => {
        return intersection(
            ...trains.map(train => {
                return train.coach?.loyaltyCards ?? [];
            }),
        );
    },
);

export default availableLoyaltyCardsSelector;
