import {createSelector} from 'reselect';

import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {orderStepSelector} from 'selectors/trains/order/orderStepSelector';
import currentSegmentDirectionAndIndexSelector from 'selectors/trains/order/currentSegmentDirectionAndIndexSelector';

const currentOrderStepDescriptionSelector = createSelector(
    [orderStepSelector, currentSegmentDirectionAndIndexSelector],
    (step, currentSegmentDirectionAndIndex) => {
        if (step === ORDER_STEP.PLACES) {
            const {direction, index} = currentSegmentDirectionAndIndex;

            return {
                step,
                direction,
                index,
            };
        }

        return {step};
    },
);

export default currentOrderStepDescriptionSelector;
