import {ITrainPriceDetails} from 'projects/trains/lib/order/getTrainPriceDetails/types/ITrainPriceDetails';

import {StoreInterface} from 'reducers/storeTypes';

import orderPriceDetailsSelector from 'selectors/trains/order/orderPriceDetailsSelector';
import currentSegmentDirectionAndIndexSelector from 'selectors/trains/order/currentSegmentDirectionAndIndexSelector';

export default function currentPriceDetailsSelector(
    state: StoreInterface,
): ITrainPriceDetails {
    const orderPriceDetails = orderPriceDetailsSelector(state);
    const {direction, index} = currentSegmentDirectionAndIndexSelector(state);

    return orderPriceDetails[direction][index];
}
