import {createStructuredSelector} from 'reselect';

import {ITrainsDirectionAndIndex} from 'types/trains/common/segment/ITrainsDirectionAndIndex';

import {StoreInterface} from 'reducers/storeTypes';

import segmentDirectionSelector from 'selectors/trains/segmentDirectionSelector';
import segmentIndexSelector from 'selectors/trains/segmentIndexSelector';

const currentSegmentDirectionAndIndexSelector = createStructuredSelector<
    StoreInterface,
    ITrainsDirectionAndIndex
>({
    direction: segmentDirectionSelector,
    index: segmentIndexSelector,
});

export default currentSegmentDirectionAndIndexSelector;
