import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';

import {StoreInterface} from 'reducers/storeTypes';

import currentTrainStateSelector from 'selectors/trains/order/currentTrainStateSelector';

/**
 * segment с которым работают в данный момент
 * @param state
 */
export default function currentSegmentSelector(
    state: StoreInterface,
): TTrainsStoreOrderSegment | null {
    const currentTrainState = currentTrainStateSelector(state);

    return currentTrainState?.segment ?? null;
}
