import {createSelector} from 'reselect';

import currentTrainDetailsSelector from 'selectors/trains/order/currentTrainDetailsSelector';
import passengersCountSelector from 'selectors/trains/order/passengersCountSelector';

import getCoachesWithEnoughPlaces from 'projects/trains/lib/order/coaches/getCoachesWithEnoughPlaces';

/**
 * Список вагонов с достаточным количеством мест для текущего поезда
 */
const currentTrainDetailsCoachesWithEnoughPlacesSelector = createSelector(
    [currentTrainDetailsSelector, passengersCountSelector],
    getCoachesWithEnoughPlaces,
);

export default currentTrainDetailsCoachesWithEnoughPlacesSelector;
