import {ITrainOrderState} from 'reducers/trains/order/types';

import {StoreInterface} from 'reducers/storeTypes';

import trainsSelector from 'selectors/trains/order/trainsSelector';
import currentSegmentDirectionAndIndexSelector from 'selectors/trains/order/currentSegmentDirectionAndIndexSelector';

/**
 * Получить state текущего поезда (segment, trainDetails, ...) с которым работают в данный момент
 */
export default function currentTrainStateSelector(
    state: StoreInterface,
): ITrainOrderState | undefined {
    const {direction, index} = currentSegmentDirectionAndIndexSelector(state);
    const trains = trainsSelector(state);

    return trains[direction][index];
}
