import mapValues from 'lodash/mapValues';
import {createSelector} from 'reselect';

import {EDirection} from 'types/common/EDirection';

import trainsSelector from 'selectors/trains/order/trainsSelector';

/**
 * Количество поездов туда и обратно в заказе
 */
export type TDirectionTrainsCount = Record<EDirection, number>;

const directionTrainsCountSelector = createSelector(
    [trainsSelector],
    (trains): TDirectionTrainsCount => {
        return mapValues(trains, direction => Object.keys(direction).length);
    },
);

export default directionTrainsCountSelector;
