import {createSelector} from 'reselect';

import {GENDER_TYPE} from 'projects/trains/constants/genders';

import trainListSelector from 'selectors/trains/order/trainListSelector';

const hasDifferentGenderInTrainsSelector = createSelector(
    [trainListSelector],
    (trains): boolean => {
        const hasFemale = trains.some(
            train => train.gender === GENDER_TYPE.FEMALE,
        );
        const hasMale = trains.some(train => train.gender === GENDER_TYPE.MALE);

        return hasFemale && hasMale;
    },
);

export default hasDifferentGenderInTrainsSelector;
