import {createSelector} from 'reselect';

import trainListSelector from 'selectors/trains/order/trainListSelector';

/**
 * В одном из поездов требуется справка (противоковидные меры)
 */
const isCovidCertificateRequiredSelector = createSelector(
    [trainListSelector],
    trains => {
        return trains.some(train => {
            return train.trainDetails?.trainDetails?.isCovidCertificateRequired;
        });
    },
);

export default isCovidCertificateRequiredSelector;
