import {createSelector} from 'reselect';
import _sum from 'lodash/sum';

import directionTrainsCountSelector from 'selectors/trains/order/directionTrainsCountSelector';

/**
 * Заказ состоит из нескольких поездов
 */
const isMultipleTrainsSelector = createSelector(
    [directionTrainsCountSelector],
    directionTrainsCount => {
        return _sum(Object.values(directionTrainsCount)) > 1;
    },
);

export default isMultipleTrainsSelector;
