import {createSelector} from 'reselect';
import flatMap from 'lodash/flatMap';
import max from 'lodash/max';

import trainListSelector from 'selectors/trains/order/trainListSelector';

import getTrainsMaxAvailablePlacesToPurchaseInCoach from 'projects/trains/lib/order/coaches/getTrainsMaxAvailablePlacesToPurchaseInCoach';

/**
 * Максимальное количество свободных мест во всех вагонах во всех поездах
 */
const maxPlacesInCoachSelector = createSelector(
    [trainListSelector],
    trainList => {
        const allCoaches = flatMap(
            trainList,
            trainState => trainState.trainDetails?.trainDetails?.coaches ?? [],
        );

        return (
            max(allCoaches.map(getTrainsMaxAvailablePlacesToPurchaseInCoach)) ??
            0
        );
    },
);

export default maxPlacesInCoachSelector;
