import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {TOrderStepDescription} from 'reducers/trains/order/thunk/changeOrderStep';
import {StoreInterface} from 'reducers/storeTypes';

import {orderStepSelector} from 'selectors/trains/order/orderStepSelector';
import currentSegmentDirectionAndIndexSelector from 'selectors/trains/order/currentSegmentDirectionAndIndexSelector';
import placesStepsSelector from 'selectors/trains/order/placesStepsSelector';

import {FIRST_PLACES_STEP} from 'projects/trains/lib/order/steps/firstPlacesStep';

export default function nextOrderStepSelector(
    state: StoreInterface,
): TOrderStepDescription {
    const orderStep = orderStepSelector(state);

    switch (orderStep) {
        case ORDER_STEP.PLACES: {
            const placesSteps = placesStepsSelector(state);
            const current = currentSegmentDirectionAndIndexSelector(state);
            const nextIndex = placesSteps.findIndex(
                step =>
                    step.direction === current.direction &&
                    step.index === current.index,
            );
            const nextPlaceStep = placesSteps[nextIndex + 1];

            if (!nextPlaceStep) {
                return {step: ORDER_STEP.PASSENGERS};
            }

            return nextPlaceStep;
        }
        case ORDER_STEP.PASSENGERS:
            return {step: ORDER_STEP.CONFIRM};
        case ORDER_STEP.CONFIRM:
            return {step: ORDER_STEP.PAYMENT};

        default: {
            return FIRST_PLACES_STEP;
        }
    }
}
