import {createSelector} from 'reselect';

import {ITrainPriceDetails} from 'projects/trains/lib/order/getTrainPriceDetails/types/ITrainPriceDetails';

import passengersCountSelector from 'selectors/trains/order/passengersCountSelector';
import trainsSelector from 'selectors/trains/order/trainsSelector';

import getApproximatedTrainPriceDetails from 'projects/trains/lib/order/getTrainPriceDetails/getApproximatedTrainPriceDetails';
import mapTrainsState, {
    TMapTrainsState,
} from 'projects/trains/lib/complexOrder/mapTrainsState';

type TOrderApproximatePriceDetailsSelector =
    TMapTrainsState<ITrainPriceDetails>;

const orderApproximatePriceDetailsSelector = createSelector(
    [passengersCountSelector, trainsSelector],
    (passengers, trains): TOrderApproximatePriceDetailsSelector => {
        return mapTrainsState(trains, train => {
            const {
                coach,
                additionalSchemeInfo,
                beddingOption,
                nonRefundableTariff,
                orderPlaces,
            } = train;

            return getApproximatedTrainPriceDetails({
                passengers,
                coach,
                additionalSchemeInfo,
                beddingOption,
                nonRefundableTariff,
                orderPlaces,
            });
        });
    },
);

export default orderApproximatePriceDetailsSelector;
