import {createSelector} from 'reselect';

import {TAllSegments} from 'projects/trains/components/TrainsOrderSegments/types';
import {EDirection} from 'types/common/EDirection';

import orderInfoSelector from 'selectors/trains/order/orderInfoSelector';
import orderSegmentsSelector from 'selectors/trains/order/orderSegmentsSelector';

import {getTrainServices} from 'projects/trains/lib/order/getTrainServices';

export default createSelector(
    [orderInfoSelector, orderSegmentsSelector],
    (orderInfo, orderSegments): TAllSegments => {
        if (!orderInfo) {
            return orderSegments;
        }

        return getTrainServices(orderInfo).reduce<TAllSegments>(
            (segments, {trainInfo}) => {
                const {arrival, departure, direction, segmentIndex} = trainInfo;
                const orderSegment = orderSegments[direction][segmentIndex];

                segments[direction][segmentIndex] = {
                    arrival,
                    departure,
                    stationFrom: {
                        ...trainInfo.stationFrom,
                        settlement: orderSegment?.stationFrom.settlement,
                    },
                    stationTo: {
                        ...trainInfo.stationTo,
                        settlement: orderSegment?.stationTo.settlement,
                    },
                    number: trainInfo.trainInfo.trainTicketNumber,
                    title: trainInfo.trainInfo.trainTitle,
                    eTicketStatus: Boolean(orderSegment?.eTicketStatus),
                    features: orderSegment?.features ?? [],
                    originalArrival: orderSegment?.originalArrival,
                    isThroughCoachArrival: orderSegment?.isThroughCoachArrival,
                };

                return segments;
            },
            {[EDirection.FORWARD]: {}, [EDirection.BACKWARD]: {}},
        );
    },
);
