import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';

import {StoreInterface} from 'reducers/storeTypes';

import orderInfoSelector from 'selectors/trains/order/orderInfoSelector';

import normalizeGenericOrderState from 'projects/trains/lib/api/utilities/normalizeGenericOrderState';

export default function orderInfoStateSelector(
    state: StoreInterface,
): EGenericOrderState | null {
    const orderInfo = orderInfoSelector(state);

    if (!orderInfo) {
        return null;
    }

    return normalizeGenericOrderState(orderInfo.state);
}
