import {createSelector} from 'reselect';

import {EDirection} from 'types/common/EDirection';
import {ITrainPriceDetails} from 'projects/trains/lib/order/getTrainPriceDetails/types/ITrainPriceDetails';

import orderInfoSelector from 'selectors/trains/order/orderInfoSelector';
import passengersCountSelector from 'selectors/trains/order/passengersCountSelector';
import insuranceIncludedSelector from 'selectors/trains/order/insuranceIncludedSelector';

import {getTrainServices} from 'projects/trains/lib/order/getTrainServices';
import getPreciseTrainPriceDetails from 'projects/trains/lib/order/getTrainPriceDetails/getPreciseTrainPriceDetails';
import {TMapTrainsState} from 'projects/trains/lib/complexOrder/mapTrainsState';

type TOrderPriceDetailsSelector = TMapTrainsState<ITrainPriceDetails>;

const orderPrecisePriceDetailsSelector = createSelector(
    [passengersCountSelector, orderInfoSelector, insuranceIncludedSelector],
    (passengers, orderInfo, insuranceIncluded): TOrderPriceDetailsSelector => {
        const priceDetails: TOrderPriceDetailsSelector = {
            [EDirection.FORWARD]: {},
            [EDirection.BACKWARD]: {},
        };

        if (!orderInfo) {
            return priceDetails;
        }

        return getTrainServices(orderInfo).reduce<TOrderPriceDetailsSelector>(
            (details, trainService) => {
                const {direction, segmentIndex} = trainService.trainInfo;

                details[direction][segmentIndex] = getPreciseTrainPriceDetails({
                    passengers,
                    coach: null,
                    additionalSchemeInfo: [],
                    trainService,
                    insuranceIncluded,
                });

                return details;
            },
            priceDetails,
        );
    },
);

export default orderPrecisePriceDetailsSelector;
