import {createSelector} from 'reselect';

import {ITrainPriceDetails} from 'projects/trains/lib/order/getTrainPriceDetails/types/ITrainPriceDetails';

import orderIsReservedSelector from 'selectors/trains/order/orderIsReservedSelector';
import orderPrecisePriceDetailsSelector from 'selectors/trains/order/orderPrecisePriceDetailsSelector';
import orderApproximatePriceDetailsSelector from 'selectors/trains/order/orderApproximatePriceDetailsSelector';

import {TMapTrainsState} from 'projects/trains/lib/complexOrder/mapTrainsState';

type TOrderPriceDetailsSelector = TMapTrainsState<ITrainPriceDetails>;

/**
 * Вычисляет цену для каждого поезда в заказе
 */
const orderPriceDetailsSelector = createSelector(
    [
        orderPrecisePriceDetailsSelector,
        orderApproximatePriceDetailsSelector,
        orderIsReservedSelector,
    ],
    (
        precisePriceDetails,
        approximatePriceDetails,
        isReserved,
    ): TOrderPriceDetailsSelector => {
        return isReserved ? precisePriceDetails : approximatePriceDetails;
    },
);

export default orderPriceDetailsSelector;
